<?php

namespace App\Http\Resources;

use App\ExportMaps\VehicleExportMap;
use App\IntegrationRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ExportMapTemplateResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = parent::toArray($request);

        return array_merge($data, [
            'data_options' => [
                'mapping_operators' => trans('export_map.operators'),
                'available_fields' => collect($this->getFieldsForType())
                    ->map(fn($value, $key) => [
                        'id' => $key,
                        'name' => "$value ($key) ",
                    ])
                    ->sortBy('name')
                    ->values(),
                'sales_channels' => app(IntegrationRepository::class)
                    ->getAllForType('sales-channels')
                    ->keys()
            ]
        ]);
    }

    private function getFieldsForType(): array
    {
        return match ($this->resource->type) {
            'vehicle' => (new VehicleExportMap())->columns(false),
            default => [],
        };
    }
}
