<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ShortcodeView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load('conditions');
        $resource = $this->resource->toArray();

        return [
            'code' => $resource,
            'types' => [
                [
                    'name' => 'Count (number of vehicles)',
                    'id' => 'count',
                ],
                [
                    'name' => 'Lowest price',
                    'id' => 'min_price',
                ],
                [
                    'name' => 'Highest price',
                    'id' => 'max_price',
                ],
                [
                    'name' => 'Lowest monthly price',
                    'id' => 'min_monthly',
                ],
                [
                    'name' => 'Highest monthly price',
                    'id' => 'max_monthly',
                ],
            ],
        ];
    }
}
