<?php

namespace App\Modules\Leasing\Jobs;

use Mtc\MercuryDataModels\KeyloopLeaseOption;

class ImportOptionsJob extends BaseImportJob
{
    protected function importItem(array $item)
    {
        KeyloopLeaseOption::query()->updateOrCreate(
            [
                'external_variant_id' => $item['external_variant_id'],
                'make_id' => $item['make_id'],
                'model_id' => $item['model_id'],
                'option_type' => $item['option_type'],
                'option_code' => $item['option_code'],
            ],
            [
                'name' => $item['name'],
                'default_vat_code' => $item['default_vat_code'],
                'was_recently_synced' => true,
            ],
        );
    }
}
