<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MakeFilterIgnoreModelSetting extends Seeder
{
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Filter makes by selected model',
                'config_key' => 'automotive-vehicle-filters-filter-makes-by-selected-model',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
