<?php

namespace App\Mail;

use App\Facades\Settings;
use App\Facades\Site;
use App\IntegrationRepository;
use App\Traits\FormatsPhoneNumber;
use App\Traits\GetsColourSettings;
use App\Traits\RetrievesGlobalContentForEmailFooter;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CompareVehiclesMail extends Mailable
{
    use Queueable;
    use SerializesModels;
    use GetsColourSettings;
    use CheckThemeTemplateTrait;
    use FormatsPhoneNumber;
    use RetrievesGlobalContentForEmailFooter;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(public readonly string $comparison_url)
    {
        //
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            from: new Address(config('mail.from.address'), config('mail.from.name')),
            subject: __('crm.vehicle_comparison_email_subject'),
        );
    }

    public function content(): Content
    {
        return new Content(
            view: $this->getTemplateName('vehicle-comparison-customer'),
            with: [
                'site_name' => Settings::get('app-name'),
                'site_logo' => Settings::get('site-logo'),
                'site_url' => Site::url(''),
                'site_logo_alternate' => Settings::get('site-alternate-logo'),
                'colours' => $this->getColourSettings(),
                'content' => '',
                'footer' => $this->getFooterFromGlobalContent('customer-enquiry-autoresponder'),
                'theme' => Settings::get('mail-customer-theme'),
                'phone_number' => Settings::get('app-contact-phone_number'),
                'phone_number_formatted' => $this->getFormattedPhoneNumber(
                    Settings::get('app-contact-phone_number', '')
                ),
                'socials' => app(IntegrationRepository::class)->findNonEmptyValuesForType('socials')
                    ->map(fn($link, $key) => [
                        'key' => $key,
                        'url' => $link,
                    ])->values(),
                'comparison_url' => $this->comparison_url,
            ],
        );
    }
}
