<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\Audit;

class ClearAudit extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:audit';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean old audit entries';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Audit::query()
            ->where('created_at', '<', Carbon::now()->subMonths(3))
            ->delete();
        return Command::SUCCESS;
    }
}
