<?php

namespace App\Console\Commands;

use App\Master\Models\BodyStyleType;
use App\Master\Models\DrivetrainType;
use App\Master\Models\FuelType;
use App\Master\Models\TransmissionType;
use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Illuminate\Console\Command;

class GenerateSlugs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'slug:generate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate taxonomy slugs for models if they are empty';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $models = [
            VehicleMake::class,
            VehicleModel::class,
            BodyStyleType::class,
            DrivetrainType::class,
            FuelType::class,
            TransmissionType::class,
        ];

        foreach ($models as $modelClass) {
            $collection = $modelClass::query()
                ->whereNull('slug')
                ->get();

            $collection->each(function ($modelInstance) {
                $modelInstance->save();
            });

            $this->info("Updated {$collection->count()} records in {$modelClass}.");
        }
    }
}
