<?php

namespace App\Listeners;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Services\FinanceService;
use Mtc\MercuryDataModels\Services\FinanceServiceHelper;

class TriggerFinanceExport
{
    use DispatchesJobs;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(private readonly FinanceService $service)
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        if (FinanceServiceHelper::hasEnabledProvider()) {
            $this->service->triggerExport();
        }
    }
}
