<?php

namespace App\Modules\CatalogOffers\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\CatalogOffer;

class CatalogOfferList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->through(fn(CatalogOffer $catalogOffer) => [
            'title' => $catalogOffer->name,
            'link' => '/manage-content/catalog-offers/edit/' . $catalogOffer->id,
            'id' => $catalogOffer->id,
        ]);
        return parent::toArray($request);
    }
}
