<?php

namespace App\Http\Resources;

use App\Facades\Site;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Tools\UiUrlGenerator;
use Mtc\MercuryDataModels\Vehicle;

class AutoImagingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->resource
            ->map(function (Vehicle $vehicle) {
                return [
                    'vrm' => $vehicle->registration_number,
                    'vin' => $vehicle->vin,
                    'make' => $vehicle->make?->name,
                    'model' => $vehicle->model?->name,
                    'variant' => $vehicle->derivative,
                    'location' => $vehicle->dealership?->name,
                    'image_count' => $vehicle->mediaUses()->count(),
                    'colour' => $vehicle->colour,
                    'transmission' => $vehicle->transmission?->name,
                    'fuel-type' => $vehicle->fuelType?->name,
                    'cap_id' => $vehicle->cap_id,
                    'odometer' => $vehicle->odometer_mi,
                    'url' => Site::vehicleUrl($vehicle),
                ];
            });
    }
}
