<?php

namespace App\Modules\SalesChannels;

use App\Contracts\AddsDealershipFields;
use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\CarWowExportJob;
use App\Traits\ChecksForExportMap;
use Illuminate\Foundation\Bus\DispatchesJobs;

class CarWow implements SalesChannel, AddsDealershipFields
{
    use DispatchesJobs;
    use ChecksForExportMap;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-car-wow-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.car_wow');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled() && !$this->hasActiveExportMap()) {
            $this->dispatch(new CarWowExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields(): array
    {
        return [
            'car-wow-dealer-id' => [
                'type' => 'text',
                'validation' => [
                    'required',
                ],
                'label' => 'Dealership name on CarWow'
            ],
        ];
    }
}
