<?php

namespace Tests\Tenant;

use App\Models\Report;
use App\ReportEngineRepository;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\Reports\Contracts\ReportLogModel;
use Tests\TenantTestCase;

class ReportContentTest extends TenantTestCase
{

    public function testReportContentEmpty()
    {
        $this->assertCount(0, $this->getReportQuery()->get());
    }

    public function testReportContentCapIdEmpty()
    {
        Vehicle::factory()->create([
            'cap_id' => ''
        ]);

        $this->assertCount(1, $this->getReportQuery()->get());
    }

    public function testReportContentCapIdNull()
    {
        Vehicle::factory()->create([
            'cap_id' => null
        ]);

        $this->assertCount(1, $this->getReportQuery()->get());
    }

    private function getReportQuery()
    {
        $report = Report::factory()->create([
            'schedule' => 'daily',
        ]);

        $report = Report::query()->find($report->id);

        $request = request()->merge([
            'schedule' => 'weekly',
            'name' => 'foo',
            'type' => 'vehicles',
            'active' => true,
            'conditions' => [
                [
                    'value' => [
                        'type' => 'and',
                        'column' => 'cap_id',
                        'operator' => '=',
                        'value' => '',
                    ],
                ],
            ],
            'recipient' => [
                'test@mail.com'
            ]
        ]);

        $report_engine_repository = new ReportEngineRepository($report, App::make(ReportLogModel::class));
        $report_engine_repository->update($request, $report);

        return $report_engine_repository->getQuery();
    }
}
