<?php

namespace App\Modules\ServiceBooking\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Dealership;

class ViewServiceCalendar extends JsonResource
{
    public static $wrap = '';
    private string $period;

    public function setMonth(Carbon $period, string $format): self
    {
        $this->period = match ($format) {
            'week' => $period->startOfWeek()->format('d M') . ' - ' . $period->copy()->endOfWeek()->format('d M'),
            'day' => $period->format('d M Y'),
            default => $period->format('F Y'),
        };

        return $this;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'data' => $this->resource,
            'locations' => Dealership::query()
                ->select(['id', 'name'])
                ->whereHas('serviceAvailability', fn($query) => $query->where('active', 1))
                ->get()
                ->prepend(['id' => 'all', 'name' => 'All']),
            'view_formats' => [
                'week' => 'Week',
                'month' => 'Month',
            ],
            'period' => $this->period,
        ];
    }
}
