<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class StripeDescriptionFormatSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Stripe',
                'name' => 'Stripe Payment Description Format',
                'config_key' => 'sales-stripe-payment-description-format',
                'value' => '',
                'type' => 'string',
                'description' => 'Allows placeholders e.g. "Payment on {make} {model}" '
                    . 'Valid replacement tokens: {make} {model} {derivative} {vrm}',
            ]
        ];
    }
}
