<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Mtc\Notifications\Models\Notification;

class DeleteOldNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notifications:prune';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete notifications older than one month for the current tenant';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $tenant = tenancy()->tenant;

        $deleted = Notification::query()
            ->where('updated_at', '<=', Carbon::now()->subDays(30))
            ->delete();

        $this->info("Deleted $deleted old notifications for tenant: " . $tenant->id);
    }
}
