<?php

namespace App\Facades;

use App\SettingRepository;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;

/**
 * @method static mixed get(string $key, $default = null)
 * @method static void update(string $key, $value)
 * @method static void make(array $values)
 * @method static bool exists(string $key)
 * @method static void delete(string $key)
 * @method static int tabOrder(string $tab)
 * @method static int sectionOrder(string $section)
 * @method static int groupOrder(string $group)
 * @method static array orderableGroups(Collection $groupNames)
 * @see SettingRepository
 */
class Settings extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'site-settings';
    }
}
