<?php

namespace App\Master\Http\Controllers;

use App\Http\Controllers\Controller;
use Mtc\MercuryDataModels\User;
use Illuminate\Http\JsonResponse;

class ImpersonateController extends Controller
{
    /**
     *  Impersonate User
     *
     * @param User $user
     * @return JsonResponse
     */
    public function impersonate(User $user): JsonResponse
    {
        session(['impersonate' => $user->id]);
        session()->forget('current_tenant');

        return response()->json([
            'success' => true
        ]);
    }


    /**
     * Stop Impersonate
     *
     * @return JsonResponse
     */
    public function stopImpersonate(): JsonResponse
    {
        session()->forget('impersonate');

        return response()->json([
            'success' => true
        ]);
    }
}
