<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OpenAIPromptSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'Open AI',
                'name' => 'Open AI User Prompt',
                'config_key' => 'open-ai-user_prompt',
                'min_tier' => 'pro',
                'type' => 'string',
                'value' => 'Generate a vehicle description from the following specifications:',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'Open AI',
                'name' => 'Open AI System Prompt',
                'config_key' => 'open-ai-system_prompt',
                'min_tier' => 'pro',
                'type' => 'string',
                'value' => 'You are a content writer for an automotive website, and will be fed information about vehicles. Respond with descriptions of the vehicles in British English.',
            ],
        ];
    }
}
