<?php

namespace Tests\Tenant;

use App\Jobs\RemoveAutoTraderReferences;
use Mtc\MercuryDataModels\Media;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class RemoveAutoTraderReferencesTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        $vehicle = Vehicle::factory()->create(['auto_trader_id' => 'abc123']);
        $m1 = Media::factory()->create(['auto_trader_id' => 'foo']);
        $m2 = Media::factory()->create(['auto_trader_id' => 'faz']);
        $m3 = Media::factory()->create(['auto_trader_id' => 'baz']);

        $vehicle->mediaUses()->create(['media_id' => $m1->id]);
        $vehicle->mediaUses()->create(['media_id' => $m2->id]);

        (new RemoveAutoTraderReferences($vehicle))->handle();

        $vehicle->refresh();
        $m1->refresh();
        $m2->refresh();
        $m3->refresh();
        $this->assertNull($vehicle->auto_trader_id);
        $this->assertNull($m1->auto_trader_id);
        $this->assertNull($m2->auto_trader_id);
        $this->assertNotNull($m3->auto_trader_id);
    }
}
