<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CodeweaversVATSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'Send VAT applicability in quote request',
                'config_key' => 'finance-codeweavers-send-vat',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Causes Codeweavers to take VAT into account for finance quotes. '
                    . 'Note that this requires Codeweavers to enable functionality on their side.',
            ]
        ];
    }
}
