<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\CarConfiguratorModel;

class CarConfiguratorList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(CarConfiguratorModel $model) => [
            'id' => $model->id,
            'title' => $model->name,
            'description' => $model->make?->name . ' ' . $model->model?->name,
        ]);
        return parent::toArray($request);
    }
}
