<?php

namespace App\Schedule;

use App\Models\ExportMap;
use App\Models\Report;
use Carbon\Carbon;

class Daily
{
    /**
     * When is going to be the next time of invoking the report
     *
     * @param Carbon $from
     * @param Report|ExportMap $report
     * @return Carbon
     */
    public function nextTime(Carbon $from, Report|ExportMap $report)
    {
        if ($report->export_time) {
            $from->setTimeFromTimeString($report->export_time);
        }
        return $from->addDay();
    }
}
