<?php

namespace Database\Seeders\Global;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Permission;
use Mtc\MercuryDataModels\Role;

class GlobalRoleSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getPermissions())
            ->each(function (string $permission) {
                Permission::query()
                    ->updateOrCreate([
                        'name' => $permission,
                        'guard_name' => 'web'
                    ]);
            });

        collect($this->getRoles())
            ->each(function (string $roleName) {
                /** @var Role $role */
                $role = Role::query()
                    ->updateOrCreate([
                        'name' => $roleName,
                        'guard_name' => 'web'
                    ]);
                $role->syncPermissions($this->permissionsForRole($roleName));
            });
    }

    private function getRoles(): array
    {
        return [
            'mtc',
            'Administrator',
            'Manager',
            'Editor',
            'Writer',
            'Customer Support',
        ];
    }

    private function getPermissions(): array
    {
        return [
            'manage-sites',
            'manage-taxonomies',
            'manage-site-users',
            'manage-settings',
            'edit-content',
            'create-content',
            'publish-content',
            'edit-global-content',
            'add-media',
            'edit-media',
            'edit-templates',
            'edit-navigation',
            'edit-elements',
            'view-enquiries',
            'edit-forms',
            'manage-reports',
            'edit-seo',
            'edit-vehicles',
            'edit-offers',
            'edit-dealerships',
            'edit-franchises',
            'view-valuations',
            'manage-properties',
            'manage-property-categories',
            'edit-new-vehicles',
            'manage-service-booking',
        ];
    }

    private function permissionsForRole(string $role): array
    {
        $all = $this->getPermissions();
        switch ($role) {
            case 'mtc':
                return $all;
            case 'Administrator':
                $except = [
                    'manage-sites',
                    'manage-taxonomies',
                    'edit-templates',
                    'edit-elements',
                    'manage-property-categories',
                ];
                return collect($all)->reject(fn ($permission) => in_array($permission, $except))->toArray();
            case 'Manager':
                $except = [
                    'manage-sites',
                    'manage-taxonomies',
                    'manage-site-users',
                    'edit-elements',
                    'edit-templates',
                    'manage-settings',
                    'manage-property-categories',
                ];
                return collect($all)->reject(fn ($permission) => in_array($permission, $except))->toArray();

            case 'Editor':
                $except = [
                    'manage-sites',
                    'manage-taxonomies',
                    'manage-site-users',
                    'manage-settings',
                    'edit-templates',
                    'edit-elements',
                    'edit-forms',
                    'manage-reports',
                    'edit-seo',
                    'edit-franchises',
                    'view-valuations',
                    'manage-properties',
                    'manage-property-categories',
                ];
                return collect($all)->reject(fn ($permission) => in_array($permission, $except))->toArray();
            case 'Writer':
                return [
                    'edit-content',
                    'create-content',
                    'edit-global-content',
                    'add-media',
                    'edit-media',
                    'edit-vehicles',
                    'edit-offers',
                ];
            case 'Customer Support':
                return [
                    'view-valuations',
                    'view-enquiries',
                ];
            default:
                return [];
        }
    }

}
