<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FuseSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Fuse CRM',
                'name' => 'Enabled',
                'config_key' => 'fuse-crm-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => '<a href="https://www.fusecrm.co.uk/" target="_blank">Fuse CRM</a> integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Fuse CRM',
                'name' => 'Client ID',
                'config_key' => 'fuse-crm-client-id',
                'type' => 'string',
                'value' => '',
                'description' => 'API client ID'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Fuse CRM',
                'name' => 'Client Secret',
                'config_key' => 'fuse-crm-client-secret',
                'type' => 'secret',
                'value' => '',
                'description' => 'API Client Secret'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Fuse CRM',
                'name' => 'API Domain',
                'config_key' => 'fuse-crm-domain',
                'type' => 'string',
                'value' => '',
                'description' => 'The domain name of the Fuse system connection. With https:// without trailing slash'
            ],
        ];
    }
}
