<?php

namespace Tests\Unit;

use App\Actions\Fortify\ResetUserPassword;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Validation\ValidationException;
use Mtc\MercuryDataModels\User;
use Tests\TestCase;

class ResetUserPasswordTest extends TestCase
{
    use RefreshDatabase;
    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testUpdatesUserPassword()
    {
        $user = User::factory()->create();

        $input = [
            'password' => 'SomethingSuperStrong2#',
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];
        (new ResetUserPassword())->reset($user, $input);
        $user->refresh();

        $this->assertTrue(password_verify('SomethingSuperStrong2#', $user->password));
    }
    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testFailsWithoutRequiredData()
    {
        $user = User::factory()->create();

        $input = [
            'password' => 'SomethingSuperStrong2#',
        ];
        $this->expectException(ValidationException::class);
        (new ResetUserPassword())->reset($user, $input);

        $input = [
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];
        $this->expectException(ValidationException::class);
        (new ResetUserPassword())->reset($user, $input);
    }
}
