<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\Crm\Models\EnquiryType;

class EnquiryTypeRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $enquiryType = EnquiryType::query()->create($entry);

        return $enquiryType->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !EnquiryType::query()
            ->where('name', $entry['name'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return EnquiryType::query()
            ->select([
                'name',
                'notes',
                'template_name',
            ])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $errors = [];
        if (EnquiryType::query()->where('name', $dataEntry['name'])->exists()) {
            $errors[] = __('validation.import_name_taken', ['name' => $dataEntry['name']]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
