<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ImageSyncExcludeStockDateSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'General',
                'name' => 'Exclude vehicles that do not have stock arrival date in past set',
                'config_key' => 'image-sync-check-stock-arrival-date',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
