<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class KeyloopReservationApiSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'Send Reservations to Keyloop',
                'config_key' => 'keyloop-reservations-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'User ID',
                'config_key' => 'keyloop-reservations-user-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.keyloop-reservations-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'User Name',
                'config_key' => 'keyloop-reservations-user-name',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.keyloop-reservations-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'Client ID',
                'config_key' => 'keyloop-reservations-client-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.keyloop-reservations-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'Client Secret',
                'config_key' => 'keyloop-reservations-client-secret',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.keyloop-reservations-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'Enterprise ID',
                'config_key' => 'keyloop-reservations-enterprise-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.keyloop-reservations-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'Salesperson ID',
                'config_key' => 'keyloop-reservations-salesperson-id',
                'type' => 'string',
                'value' => '',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'Salesperson Name',
                'config_key' => 'keyloop-reservations-salesperson-name',
                'type' => 'string',
                'value' => '',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Keyloop',
                'name' => 'Update local status from Keyloop availability',
                'description' => 'Update local vehicle status when reservation availability is checked via the Keyloop API',
                'config_key' => 'keyloop-reservations-update-local-status',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
