<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\MotoNovoExportJob;
use App\Traits\ChecksForExportMap;
use App\Traits\ExportMapCheckRules;
use Illuminate\Foundation\Bus\DispatchesJobs;

class MotoNovo implements SalesChannel
{
    use DispatchesJobs;
    use ChecksForExportMap;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-moto-novo-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.moto_novo');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled() && !$this->hasActiveExportMap()) {
            $this->dispatch(new MotoNovoExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'moto-novo-dealer-id' => [
                'type' => 'text',
                'label' => 'Dealership ID on MotoNovo'
            ],
        ];
    }
}
