<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AdvancedVersioningSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Versioning',
                'name' => 'Versioning to use content review mode',
                'config_key' => 'pages-versioning-content-review-mode',
                'type' => 'boolean',
                'value' => false,
                'description' => 'In collaboration mode "Mark for review" and "Request changes" are enabled for '
                    . 'content version sections',
                'order' => 20,
            ],
        ];
    }
}
