<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EVAValuationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Enabled',
                'config_key' => 'valuation-eva-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Client ID',
                'config_key' => 'valuation-eva-client-id',
                'type' => 'string',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Client Secret',
                'config_key' => 'valuation-eva-client-secret',
                'type' => 'secret',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Live mode',
                'config_key' => 'valuation-eva-use-live',
                'type' => 'boolean',
                'value' => app()->isProduction(),
                'superadmin' => true,
                'description' => 'When enabled uses Live eVA environment, when disabled uses test environment'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Question set ID to use',
                'config_key' => 'valuation-eva-question-set-id',
                'type' => 'string',
                'value' => 129,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Question category code',
                'config_key' => 'valuation-eva-question-category-code',
                'type' => 'string',
                'value' => 'LQS',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Assumed vehicle overall condition',
                'config_key' => 'valuation-eva-question-overall-condition',
                'type' => 'string',
                'value' => 'Good',
                'choices' => [
                    ['value' => 'Excellent', 'name' => 'Excellent'],
                    ['value' => 'Good', 'name' => 'Good'],
                    ['value' => 'Average', 'name' => 'Average'],
                    ['value' => 'Fair', 'name' => 'Fair'],
                    ['value' => 'Poor', 'name' => 'Poor'],
                ],
                'description' => 'Vehicle valuation will be based on assumption for the overall condition',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'eVA',
                'name' => 'Assumed LCV usage type',
                'config_key' => 'valuation-eva-question-lcv-usage',
                'type' => 'string',
                'value' => '2',
                'choices' => [
                    ['value' => '1', 'name' => 'Light use (Meter Reading, Florist etc.)'],
                    ['value' => '2', 'name' => 'Medium use (Parcel Delivery, Electrician, Plumber etc.)'],
                    ['value' => '3', 'name' => 'Heavy use (Building/Construction, Painter and Decorator etc.)'],
                ],
            ],
        ];
    }
}
