<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ReservationPriceMotorcyclesSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'General',
                'name' => 'Reserve Price (Motorcycle)',
                'config_key' => 'sales-reserve-price-motorcycle',
                'type' => 'number',
                'value' => 99,
            ],
        ];
    }
}
