<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ValuationEmailSelectedValueSeeder extends Seeder
{
    public function run()
    {
        collect($this->settings())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function settings(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'General',
                'name' => 'Valuation price to show in confirmation email',
                'config_key' => 'valuation-email-price-to-show',
                'type' => 'string',
                'value' => 'all',
                'choices' => [
                    ['value' => 'all', 'name' => 'All prices'],
                    ['value' => 'clean_price', 'name' => 'Clean price'],
                    ['value' => 'average_price', 'name' => 'Average price'],
                    ['value' => 'below_price', 'name' => 'Below price'],
                ],
            ],
        ];
    }
}
