<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleOfferSlugTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Offers',
                'name' => 'Vehicle Offer Slug Type',
                'config_key' => 'automotive-vehicle-offers-slug_type',
                'type' => 'string',
                'value' => 'offer_name',
                'choices' => [
                    [
                        'value' => 'offer_name',
                        'name' => 'Offer Name',
                    ],
                    [
                        'value' => 'offer_id',
                        'name' => 'Sequential Numeric ID',
                    ],
                ],
            ],
        ];
    }
}
