<?php

namespace App\Modules\Leasing;

use App\Modules\Leasing\Jobs\ImportColoursJob;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\KeyloopLeaseColour;

class KeyloopFleetKompactColourImporter extends KeyloopFleetKompactImporterBase
{
    protected function filter(Collection $data): bool
    {
        return array_key_exists($data['full-fran'], $this->enabled_keyloop_makes);
    }

    protected function prepareForImport(): void
    {
        KeyloopLeaseColour::query()->update([
            'was_recently_synced' => false,
        ]);
    }

    protected function importItems(Collection $data): void
    {
        $this->dispatch(new ImportColoursJob($data->map(fn ($item) => [
            'make_id' => $this->getVehicleMake($item['full-fran']),
            'colour_code' => $item['colourcode'],
            'generic_colour_code' => $item['generic-colour-code'],
            'name' => $this->getUtf8String($item['colour-description']),
        ])));
    }
}
