<?php

namespace App\Modules\Valuation\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ValuationAdjustmentView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->load('rules');

        $this->resource->operators = [
            [
                'name' => 'Equals (=)',
                'id' => '=',
            ],
            [
                'name' => 'At least (>=)',
                'id' => '>=',
            ],
            [
                'name' => 'Higher than (>)',
                'id' => '>',
            ],
            [
                'name' => 'At most (<=)',
                'id' => '<=',
            ],
            [
                'name' => 'Less than (<)',
                'id' => '<',
            ],
        ];

        $this->resource->fields = [
            [
                'name' => 'Vehicle Make',
                'id' => 'make',
            ],
            [
                'name' => 'Vehicle Model',
                'id' => 'model',
            ],
            [
                'name' => 'Mileage',
                'id' => 'mileage',
            ],
            [
                'name' => 'Manufacture year (NOT SUPPORTED)',
                'id' => 'manufacture_year',
            ],
            [
                'name' => 'Registration year',
                'id' => 'date_of_registration',
            ],
            [
                'name' => 'Fuel type',
                'id' => 'fuel_type',
            ],
            [
                'name' => 'Transmission',
                'id' => 'transmission',
            ],
            [
                'name' => 'Body Type',
                'id' => 'body_type',
            ],
            [
                'name' => 'Engine size (cc)',
                'id' => 'engine_size_cc',
            ],
            [
                'name' => 'Door count (NOT SUPPORTED)',
                'id' => 'door_count',
            ],
        ];

        $response = $this->resource->toArray();

        $response['rules'] = $this->resource->rules->map(function ($rule) {
            return ['value' => $rule];
        })->toArray();

        return $response;
    }
}
