<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class UpdateSeoTrackingCode extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->settings())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function settings(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Analytics',
                'name' => 'Google Tag Manager ID',
                'config_key' => 'seo-ga_id',
                'type' => 'string',
                'description' => '"GTM-XXXXXXX" code. Allows implementing '
                    . '<a href="https://developers.google.com/tag-platform/tag-manager" target="_blank">'
                    . 'Google Tag Manager</a> container and tracking.',
            ],
        ];
    }
}
