<?php

namespace App\Http\Controllers;

use App\Jobs\HandleAutoGrabNotification;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\ApiNotification;

class AutoGrabNotificationController extends Controller
{
    use DispatchesJobs;

    public function store(Request $request)
    {
        $apiNotification = ApiNotification::query()
            ->create([
                'provider' => 'autograb',
                'data' => $request->input(),
                'headers' => $request->header(),
                'data_model' => 'vehicle',
                'reference' => $request->input('rego') ?? $request->input('vin'),
            ]);

        $this->dispatch(new HandleAutoGrabNotification($request->input(), $apiNotification));

        return response([
            'status' => 'received'
        ]);
    }
}
