<?php

namespace App\Listeners;

use App\VehicleStockSyncLogRepository;
use Mtc\MercuryDataModels\Events\VehicleTrashed;

class DeleteVehicleStockSyncRecords
{
    public function __construct(private VehicleStockSyncLogRepository $repository)
    {
        //
    }

    public function handle(VehicleTrashed $event)
    {
        if (!$this->repository->enabled()) {
            return;
        }

        $this->repository->deleteAllExceptLast($event->vehicle);
    }
}
