<?php

namespace Database\Seeders\Global;

use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Illuminate\Database\Seeder;

class ToyotaCorollaCrossSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run(): void
    {
        $make = VehicleMake::query()->where('slug', 'toyota')->first();

        if (empty($make)) {
            return;
        }

        VehicleModel::query()->updateOrCreate([
            'make_id' => $make->id,
            'slug' => 'corolla-cross',
            'name' => 'Corolla Cross',
            'keyloop_id' => 'COROLLA CROSS',
            'type' => 'car',
        ]);
    }
}
