<?php

namespace App\Http\Controllers;

use App\Http\Resources\InvoiceListResource;
use App\Http\Resources\InvoiceViewResource;
use Mtc\MercuryDataModels\Invoice;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return InvoiceListResource
     */
    public function index()
    {
        $invoices = tenancy()->tenant->invoices()
            ->latest()
            ->paginate();
        return new InvoiceListResource($invoices);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return InvoiceViewResource
     */
    public function show(Invoice $invoice)
    {
        return new InvoiceViewResource($invoice);
    }
}
