<?php

namespace App\Master\Http\Requests;

use App\Models\ContentSync;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class UpdateContentSyncRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return Auth::check()
            && Auth::user()->hasRole('mtc')
            && $this->route('sync')->user_id === Auth::id();
    }
}
