<?php

namespace App\Modules\Leasing;

use App\Modules\Leasing\Jobs\ImportOptionPriceJob;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\KeyloopLeaseOptionPrice;

class KeyloopFleetKompactOptionPriceImporter extends KeyloopFleetKompactImporterBase
{
    protected function filter(Collection $data): bool
    {
        if (
            array_key_exists($data['fran'], $this->enabled_keyloop_makes)
            && array_key_exists($data['fran'], $this->enabled_keyloop_models)
            && array_key_exists($data['model-code'], $this->enabled_keyloop_models[$data['fran']])
        ) {
            return true;
        }

        return false;
    }

    protected function prepareForImport(): void
    {
        KeyloopLeaseOptionPrice::query()->update([
            'was_recently_synced' => false,
        ]);
    }

    protected function importItems(Collection $data): void
    {
        $this->dispatch(new ImportOptionPriceJob($data->map(fn ($item) => $item->toArray())));
    }
}
