<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FinanceImportSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => "Delete a vehicle's saved finance provider quotes if the provider stops returning quotes",
                'config_key' => 'finance-delete-examples-when-no-quotes',
                'description' => 'A finance provider could stop returning quotes for a vehicle '
                    . 'if there is a problem with the service or if the vehicle is no longer eligible for finance',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => "Delete a vehicle's stock import quotes if the finance provider returns quotes",
                'config_key' => 'finance-overwrite-import-quotes-with-provider-quotes',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
