<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SalesforceCrmBookingTimeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Booking time for "Anytime"',
                'description' => 'Map enquiry form "Anytime" to an actual time. Must be in 24 hour clock format e.g. 16:00:00',
                'config_key' => 'salesforce-crm-booking-time-anytime',
                'type' => 'string',
                'value' => '00:00:00',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Booking time for "Morning"',
                'description' => 'Map enquiry form "Morning" to an actual time. Must be in 24 hour clock format e.g. 16:00:00',
                'config_key' => 'salesforce-crm-booking-time-morning',
                'type' => 'string',
                'value' => '10:00:00',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Booking time for "Afternoon"',
                'description' => 'Map enquiry form "Afternoon" to an actual time. Must be in 24 hour clock format e.g. 16:00:00',
                'config_key' => 'salesforce-crm-booking-time-afternoon',
                'type' => 'string',
                'value' => '13:00:00',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Salesforce',
                'name' => 'Booking time for "Evening"',
                'description' => 'Map enquiry form "Evening" to an actual time. Must be in 24 hour clock format e.g. 16:00:00',
                'config_key' => 'salesforce-crm-booking-time-evening',
                'type' => 'string',
                'value' => '16:00:00',
            ],
        ];
    }
}
