<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Jobs\MotoNovoExportJob;
use App\Jobs\MotorsCoUkExportJob;
use App\Modules\SalesChannels\MotoNovo;
use App\Modules\SalesChannels\MotorsCoUk;
use Database\Seeders\Tenant\MotoNovoExportSeeder;
use Database\Seeders\Tenant\MotorsCoUkExportSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;

class MotoNovoExportTest extends TestCase
{
    use DatabaseMigrations;

    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('moto-novo-export');
        $this->seed(MotoNovoExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-moto-novo-file-name', 'foo.csv');

        $this->dispatch(new MotoNovoExportJob());

        Storage::disk('moto-novo-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'moto-novo')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Storage::fake('moto-novo-export');
        $this->seed(MotoNovoExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-moto-novo-file-name', 'foo.csv');
        Settings::update('sales-channels-moto-novo-enabled', true);

        app(MotoNovo::class)->runScheduledExport();

        Storage::disk('moto-novo-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'moto-novo')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
