<?php

namespace Tests\Feature;

use App\Console\Commands\NotifyOverdueInvoices;
use App\Mail\OverdueInvoiceNotification;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Mail;
use Mtc\MercuryDataModels\Invoice;
use Mtc\MercuryDataModels\Tenant;
use Tests\TestCase;

class NotifyOverdueInvoicesTest extends TestCase
{
    use RefreshDatabase;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testNoNotifications(): void
    {
        Mail::fake();
        $this->artisan(NotifyOverdueInvoices::class);

        Mail::assertNothingSent();
    }

    public function testHasNotifications(): void
    {
        $tenant = Tenant::factory()->create();
        Invoice::factory()->create([
            'paid_at' => null,
            'due_at' => Carbon::now()->subDays(40),
            'tenant_id' => $tenant->id,
        ]);

        Mail::fake();
        $this->artisan(NotifyOverdueInvoices::class);

        Mail::assertQueued(OverdueInvoiceNotification::class);
    }
}
