<?php

namespace App\Http\Controllers;

use App\Http\Requests\SelectionSearchSearchRequest;
use App\Http\Resources\LeaseVariantListResource;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;

class LeaseVehicleController extends Controller
{
    public function __construct()
    {
        $this->middleware([
            'permission:edit-vehicles',
        ]);
    }

    public function index(SelectionSearchSearchRequest $request)
    {
        $vehicles = KeyloopLeaseVehicleVariant::query()
            ->when($request->filled('selections'), fn($query) => $query->setSelections($request->getSelections()))
            ->paginate();

        return new LeaseVariantListResource($vehicles);
    }

    public function update(Request $request)
    {
        collect($request->input('vehicles'))->each(function ($vehicle) {
            KeyloopLeaseVehicleVariant::query()
                ->where('id', $vehicle['id'])
                ->update([
                    'featured' => $vehicle['featured']
                ]);
        });
    }
}
