<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferTypeFilterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Offer Type',
                'config_key' => 'automotive-vehicle-filters-offer_type',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
