<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Facades\Settings;

class SitePhoneNumberCheck extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function key(): string
    {
        return 'site_phone_number';
    }

    public function handle(): bool
    {
        $has_phone = !empty(Settings::get('app-contact-contact_number'));
        if (!$has_phone) {
            $this->failure_reason = __('go-live.errors.no-phone-number');
        }
        return $has_phone;
    }
}
